//=============================================================================
// HS_RestrictedShop.js
// ----------------------------------------------------------------------------
// Copyright (c) 2017 n2naokun(柊菜緒)
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 1.1.3 2024/12/06 複数グループを指定した時のバグを修正
// 1.1.2 2024/12/06 プラグインコマンド関連のバグを修正
// 1.1.1 2024/10/18 アイテムに複数のグループを指定できるように変更
// 1.1.0 2024/10/18 プラグインコマンドのMZ対応
// 1.0.1 2018/08/08 売却可能なアイテムが無い場合の表示を追加（通常ショップも表示）
// 1.0.0 2018/08/05 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/n2naokun/
// [GitHub] : https://github.com/n2naokun/
//=============================================================================

/*:
 * @plugindesc ショップでアイテムを売る時に指定したアイテム以外を非表示にする。
 * @author n2naokun(柊菜緒)
 *
 * @help 使い方
 * アイテムのメモ欄に
 * <Rgroup:グループ名>
 * の様に記述する。（グループ名は任意に設定可能）
 * 
 * ショップを開く前にプラグインコマンドで
 * Rshop グループ名
 * を実行するとグループ名に合致したアイテムのみを売るアイテムに表示する事ができる。
 * 
 * 
 * 利用規約：
 *  作者に無断で改変、再配布が可能で、利用形態（商用、18禁利用等）
 *  についても制限はありません。
 *  このプラグインはもうあなたのものです。
 * 
 * @command RsShop
 * @text 売却制限ショップを開く
 * @desc 売却制限ショップを開きます。
 * 
 * @arg GroupName
 * @text アイテムグループ名
 * @desc ショップに表示するアイテムのグループ名
 * @type text[]
 */

// ESLint向けグローバル変数宣言
/*global */

"use strict";//厳格なエラーチェック

(function (_global) {
   const PluginName = "HS_RestrictedShop";
   _global.Imported = _global.Imported || {};
   _global.Imported[PluginName] = true;
   // 他のプラグインとの連携用シンボル

   const pname = PluginName;

   Game_Temp.prototype.setRshop = function (flag) {
      this._rshop = !!flag;
   };

   Game_Temp.prototype.isRshop = function () {
      return !!this._rshop;
   };

   Game_Temp.prototype.setRgroup = function (rgroup) {
      if (typeof rgroup === 'string') {
         try {
            this._rgroup = JSON.parse(rgroup);
         } catch (error) {
            console.error(error);
            rgroup = rgroup.trim();
            if (rgroup.includes(',')) {
               rgroup = rgroup.split(',');
               rgroup = rgroup.map(function (item) {
                  return item.trim();
               });
               rgroup = rgroup.filter(function (item) {
                  return item;
               });
               this._rgroup = rgroup;
               return;
            }
            if (rgroup.includes(' ')) {
               rgroup = rgroup.split(' ');
               rgroup = rgroup.map(function (item) {
                  return item.trim();
               });
               rgroup = rgroup.filter(function (item) {
                  return item;
               });
               this._rgroup = rgroup;
               return;
            }
            this._rgroup = [rgroup];
         }
         return;
      } else if (Array.isArray(rgroup)) {
         this._rgroup = rgroup || [];
         return;
      }
   };

   Game_Temp.prototype.rGroup = function () {
      return this._rgroup || [];
   };



   if (Utils.RPGMAKER_NAME !== 'MZ') {
      var Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
      Game_Interpreter.prototype.pluginCommand = function (command, args) {
         Game_Interpreter_pluginCommand.apply(this, arguments);

         switch (command) {
            case "Rshop":
               $gameTemp.setRshop(true);
               $gameTemp.setRgroup(args);
               break;
         }
      };
   } else {
      PluginManager.registerCommand(pname, "RsShop", args => {
         $gameTemp.setRshop(true);
         $gameTemp.setRgroup(args['GroupName']);
      });
   }


   const GroupRegExp = /<Rgroup:(.+)>/g;
   Window_ShopSell.prototype.makeItemList = function () {
      this._data = $gameParty.allItems().filter(function (item) {
         if ($gameTemp.isRshop() && ($gameTemp.rGroup().length >= 1)) {
            var rgroup = $gameTemp.rGroup();
            const rgroups = item.note.match(GroupRegExp) || [];
            var included = false;
            for (let i = 0; i < rgroup.length; i++) {
               if (rgroups) {
                  included = rgroups.includes(`<Rgroup:${rgroup[i]}>`);
               } else {
                  break;
               }
               if (included) break;
            }
            return this.includes(item) && rgroups && included;
         } else {
            return this.includes(item);
         }
      }, this);
      if (this.includes(null)) {
         this._data.push(null);
      }
   };

   var Window_ShopSell_select = Window_ShopSell.prototype.select;
   Window_ShopSell.prototype.select = function (index) {
      Window_ShopSell_select.apply(this, arguments);
      if (this._data && this._data.length === 0 && this._helpWindow && this.active) {
         this._helpWindow.setText("No items available to sell");
      }
   };


   var Scene_Shop_terminate = Scene_Shop.prototype.terminate;
   Scene_Shop.prototype.terminate = function () {
      Scene_Shop_terminate.call(this);
      $gameTemp.setRshop();
      $gameTemp.setRgroup();
   };

})(this);